<?php
    /**
    *
    * copyright (c) 2013-2020 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    //array associativo che contiene le classi da aggiungere ai vari div per personalizzare l'aspetto
    $aspettiSito = array(
        "classico" => array(
            "nome"         => "Classico",
            "icona"        => "template_pag_default.svg",
            'body'         => "d-flex flex-column",
            'cartellaMenu' => "classico",
            'cartellaTemplatePagina' => "classico",
            'cartellaFooter' => "classico",
            'menuPrincipale'   => "",
            //	Personalizzazioni menu
            'personalizzazioniMenu' => array(
                'divContenitoreMenu'   => "collapse navbar-collapse",
                'classeMenu'   => "navbar-nav ml-auto",
                'elementoMenu' => "nav-item sliding-u-l-r-l",
                'linkMenu' => "nav-link",
                'elementoSottomenu' => "dropdown-item",
                'tipoRicerca' => "modal"
            )),
        
        "menuBoxato" => array(
            "nome"         => "Menu boxato",
            "icona"        => "template_pag_boxato.svg",
            'body'         => "d-flex flex-column",
            'cartellaMenu' => "menuBoxato",
            'cartellaTemplatePagina' => "classico",
            'cartellaFooter' => "classico",
            'menuPrincipale'   => "",
            //	Personalizzazioni menu
            'personalizzazioniMenu' => array(
                'divContenitoreMenu'   => "collapse navbar-collapse",
                'classeMenu'   => "navbar-nav ml-auto",
                'elementoMenu' => "nav-item sliding-u-l-r-l",
                'linkMenu' => "nav-link",
                'elementoSottomenu' => "dropdown-item",
                'tipoRicerca' => "modal",
            )),
        
        "logoSinistraMenuCentrato" => array(
            "nome"         => "Logo a sinistra, menu centrato",
            "icona"        => "template_pag_logo_sx_menu_centrato.svg",
            'body'         => "d-flex flex-column",
            'cartellaMenu' => "logoSinistraMenuCentrato",
            'cartellaTemplatePagina' => "classico",
            'cartellaFooter' => "classico",
            'menuPrincipale'   => "",
            //	Personalizzazioni menu
            'personalizzazioniMenu' => array(
                'divContenitoreMenu'   => "collapse navbar-collapse",
                'classeMenu'   => "navbar-nav mx-auto",
                'elementoMenu' => "nav-item sliding-u-l-r-l",
                'linkMenu' => "nav-link",
                'elementoSottomenu' => "dropdown-item",
                'tipoRicerca' => "modal",
            )),
        
        "menuSuDueLivelli" => array(
            "nome"         => "Menu su due livelli",
            "icona"        => "template_pag_menu_su_due_righe.svg",
            'body'         => "d-flex flex-column menu-centrato menu-due-livelli",
            'cartellaMenu' => "menuSuDueLivelli",
            'cartellaTemplatePagina' => "classico",
            'cartellaFooter' => "classico",
            'menuPrincipale'   => "",
            //	Personalizzazioni menu
            'personalizzazioniMenu' => array(
                'divContenitoreMenu'   => "collapse navbar-collapse",
                'classeMenu'   => "navbar-nav mx-auto",
                'elementoMenu' => "nav-item sliding-u-l-r-l",
                'linkMenu' => "nav-link",
                'elementoSottomenu' => "dropdown-item",
                'tipoRicerca' => "modal",
            ),
            'personalizzazioniMenuSecondario' => array(
                'divContenitoreMenu'   => "collapse navbar-collapse",
                'classeMenu'   => "navbar-nav ml-auto",
                'elementoMenu' => "nav-item sliding-u-l-r-l",
                'linkMenu' => "nav-link",
                'elementoSottomenu' => "dropdown-item",
                'tipoRicerca' => "modal",
            )),
        
        "menuCentrato" => array(
            "nome"         => "Menu centrato",
            "icona"        => "template_pag_centrato.svg",
            'body'         => "menu-centrato d-flex flex-column",
            'cartellaMenu' => "menuCentrato",
            'cartellaTemplatePagina' => "classico",
            'cartellaFooter' => "classico",
            'menuPrincipale'   => "",
            //	Personalizzazioni menu
            'personalizzazioniMenu' => array(
                'divContenitoreMenu'   => "collapse navbar-collapse mx-lg-auto",
                'classeMenu'   => "navbar-nav ml-auto",
                'elementoMenu' => "nav-item sliding-u-l-r-l",
                'linkMenu' => "nav-link",
                'elementoSottomenu' => "dropdown-item",
                'tipoRicerca' => "modal"
            )),
        
        "logoCentrale" => array(
            "nome"         => "Logo centrale",
            "icona"        => "template_pag_logo_centrale.svg",
            'body'         => "logo-centrato d-flex flex-column",
            'cartellaMenu' => "logoCentrale",
            'cartellaTemplatePagina' => "classico",
            'cartellaFooter' => "classico",
            'menuPrincipale'   => "",
            //	Personalizzazioni menu
            'personalizzazioniMenu' => array(
                'divContenitoreMenu'   => "collapse navbar-collapse mx-lg-auto text-center",
                'classeMenu'   => "navbar-nav mx-auto d-flex align-items-center",
                'elementoMenu' => "nav-item sliding-u-l-r-l",
                'linkMenu' => "nav-link text-nowrap",
                'elementoSottomenu' => "dropdown-item",
                'tipoRicerca' => "modal"
            )),
        
        "menuTuttoSchermo" => array(
            "nome"         => "Menu a tutto schermo",
            "icona"        => "template_pag_menu_fullscreen.svg",
            'body'         => "menu-a-tutto-schermo d-flex flex-column",
            'cartellaMenu' => "menuTuttoSchermo",
            'cartellaTemplatePagina' => "menuTuttoSchermo",
            'cartellaFooter' => "menuTuttoSchermo",
            'menuPrincipale'   => "",
            //	Personalizzazioni menu
            'personalizzazioniMenu' => array(
                'divContenitoreMenu'   => "collapse navbar-collapse mx-lg-auto text-center",
                'classeMenu'   => "list-unstyled text-center",
                'elementoMenu' => "",
                'linkMenu' => "",
                'elementoSottomenu' => "",
                'tipoRicerca' => "inline"
            )),
        
        "sidebarSxFissa" => array(
            "nome"         => "Colonna laterale sinistra fissa",
            "icona"        => "template_pag_sidebar_sx.svg",
            'body'         => "barra-laterale fissa-sx",
            'cartellaMenu' => "sidebarSxFissa",
            'cartellaTemplatePagina' => "sidebarSxFissa",
            'cartellaFooter' => "sidebarSxFissa",
            'menuPrincipale'   => "",
            //	Personalizzazioni menu
            'personalizzazioniMenu' => array(
                'divContenitoreMenu'   => "",
                'classeMenu'   => "list-unstyled",
                'elementoMenu' => "",
                'linkMenu' => "",
                'elementoSottomenu' => "dropdown-item",
                'tipoRicerca' => "inline",
            )),
   
        "sidebarScomparsaDx" => array(
            "nome"         => "Colonna laterale destra a scomparsa",
            "icona"        => "template_pag_sidebar_dx.svg",
            'body'         => "barra-laterale",
            'cartellaMenu' => "sidebarScomparsaDx",
            'cartellaTemplatePagina' => "sidebarScomparsaDx",
            'cartellaFooter' => "sidebarScomparsaDx",
            'menuPrincipale'   => "",
            //	Personalizzazioni menu
            'personalizzazioniMenu' => array(
                'divContenitoreMenu'   => "",
                'classeMenu'   => "list-unstyled",
                'elementoMenu' => "",
                'linkMenu' => "",
                'elementoSottomenu' => "dropdown-item",
                'tipoRicerca' => "inline",
            )),
        
        "sidebarScomparsaSx" => array(
            "nome"         => "Colonna laterale sinistra a scomparsa",
            "icona"        => "template_pag_fullscreen_sx.svg",
            'body'         => "barra-laterale sinistra",
            'cartellaMenu' => "sidebarScomparsaSx",
            'cartellaTemplatePagina' => "sidebarScomparsaSx",
            'cartellaFooter' => "sidebarScomparsaSx",
            'menuPrincipale'   => "",
            //	Personalizzazioni menu
            'personalizzazioniMenu' => array(
                'divContenitoreMenu'   => "",
                'classeMenu'   => "list-unstyled",
                'elementoMenu' => "",
                'linkMenu' => "",
                'elementoSottomenu' => "dropdown-item",
                'tipoRicerca' => "inline",
            ),
            'personalizzazioniMenuSecondario' => array(
                'divContenitoreMenu'   => "collapse navbar-collapse",
                'classeMenu'   => "navbar-nav ml-auto",
                'elementoMenu' => "nav-item sliding-u-l-r-l",
                'linkMenu' => "nav-link",
                'elementoSottomenu' => "dropdown-item",
                'tipoRicerca' => "modal"
            )),
        
        "sidebarScomparsaSxLogoCentrale" => array(
            "nome"         => "Colonna laterale sinistra a scomparsa con logo centrale",
            "icona"        => "template_pag_fullscreen_sx_logo_centrale.svg",
            'body'         => "barra-laterale sinistra logoCentrale",
            'cartellaMenu' => "sidebarScomparsaSxLogoCentrale",
            'cartellaTemplatePagina' => "sidebarScomparsaSxLogoCentrale",
            'cartellaFooter' => "sidebarScomparsaSxLogoCentrale",
            'menuPrincipale'   => "",
            //	Personalizzazioni menu
            'personalizzazioniMenu' => array(
                'divContenitoreMenu'   => "",
                'classeMenu'   => "list-unstyled",
                'elementoMenu' => "",
                'linkMenu' => "",
                'elementoSottomenu' => "dropdown-item",
                'tipoRicerca' => "inline",
            ),
            'personalizzazioniMenuSecondario' => array(
                'divContenitoreMenu'   => "collapse navbar-collapse",
                'classeMenu'   => "navbar-nav d-inline-block ml-auto align-self-center",
                'elementoMenu' => "nav-item sliding-u-l-r-l px-2",
                'linkMenu' => "nav-link",
                'elementoSottomenu' => "dropdown-item",
                'tipoRicerca' => "modal"
            ))
    );

    /*
     * Questo array contiene le personalizzazioni stilistiche per il menu secondario
     * 
     * la voce classe menu contiene al suo interno la stringa allineamento_menu che viene
     * rimpiazzata dall'opzione scelta nelle impostazioni di Geecom (barra superiore) 
     */
    $personalizzazioniMenuBarraSuperiore = array(
        'divContenitoreMenu'   => "collapse navbar-collapse",
        'classeMenu'   => "navbar-nav allineamento_menu",
        'elementoMenu' => "nav-item",
        'linkMenu' => "nav-link",
        'elementoSottomenu' => "dropdown-item",
        'tipoRicerca' => "modal");
            
   /*
    *	Elenco dei template disponibili per personalizzare pagine e gallerie di Geecom
    */
    $templatePagine = array(
        'Senza colonne laterali'     => "senzaColonneLaterali.php",
        'Immagine a tutta larghezza' => "immagineATuttaLarghezza.php",
        'Home page'                  => "homePage.php",
        'Colonna sinistra attiva'    => "colonnaSinistraAttiva.php",
        'Colonna destra attiva'      => "colonnaDestraAttiva.php",
        'Landing page'               => "landingPage.php",
        'Landing page logo grande'   => "landingPageLogoGrande.php",
        'Landing logo immagine sfondo' => "landingLogoSuImmagineSfondo.php",
        'Template vuoto'             => "templateVuoto.php"
    );
    
   /*
    *	Elenco dei template disponibili per gli elementi del portfolio
    */
    $templateElementiPortfolio = array(
        'Slider di immagini - 2/3 - 1/3' => "temaElementoPortfolioGalleriaImmagini-8-4.php",
        'Immagini in sequenza - 2/3 - 1/3' => "temaElementoPortfolioSequenzaImmagini-8-4.php",
        'Slider di immagini - 1/2 - 1/2' => "temaElementoPortfolioGalleriaImmagini-6-6.php",
        'Immagini in sequenza - 1/2 - 1/2' => "temaElementoPortfolioSequenzaImmagini-6-6.php",
        'Slider di immagini - 1/1' => "temaElementoPortfolioGalleriaImmagini-12-12.php",
        'Immagini in sequenza - 1/1' => "temaElementoPortfolioSequenzaImmagini-12-12.php"
    );

   /*
    *	Elenco dei template disponibili per personalizzare i prodotti con il componente ecommerce di Geecom
    */
    $templateProdotti = array(
        'Template base' => "templateBaseProdotto.php",
        'Senza colonne laterali' => "prodottoSenzaColonneLaterali.php",
        'Colonna laterale in alto a destra' => "colonnaLateraleInAltoADestra.php"
    );
    
    /*
     * indicazioni tema
     */
    $indicazioniTema = array(
        'lunghezzaLogo' => "300px",
        'altezzaLogo'   => "88px"
    );
    
    /*
     * Questo array contiene tutte le dimensioni colonna disponibili per questo tema
     * richiamato da creaContenuto.php e tutti i componenti che consentono di scegliere le posizioni
     */
    $arrayDimensioniColonna = array("col-12"=>"intera riga","col-lg-10 mx-auto"=>"5/6 della riga","col-lg-8 mx-auto"=>"2/3 della riga", "col-md-6 mx-auto"=>"1/2 della riga","col-md-4 mx-auto"=>"1/3 della riga","col-md-6 col-lg-3 mx-auto"=>"1/4 della riga");
    
    /*
     * Questo array contiene tutte le altezze disponibili per questo tema
     * richiamato da tutti i componenti che consentono di scegliere l'altezza del componente
     */
    $arrayAltezze = array(""=>"Nessuna","h20"=>"20% dello schermo","h30"=>"30% dello schermo","h40"=>"40% dello schermo","h50"=>"50% dello schermo","h60"=>"60% dello schermo","h70"=>"70% dello schermo","h80"=>"80% dello schermo","h90"=>"90% dello schermo","h100"=>"100% dello schermo");
    
    /*
     * Questo array contiene tutte i colori di sfondo disponibili
     * richiamato nella pagina impostazioni (e le sue varie tab), nel file modalModificheCmponenti.php e in vari componenti
     */
    $arrayColori = array("bg-transparent no-shadow border-0"=>"Trasparente","bg-primary"=>"Primary","bg-secondary"=>"Secondary","bg-success"=>"Success","bg-info"=>"Info","bg-warning"=>"Warning","bg-danger"=>"Danger","bg-light"=>"Light","bg-dark"=>"Dark","bg-white"=>"Bianco");
    
    /*
     * Questo array contiene le animazioni disponibili
     * richiamato nelnel file modalModificheCmponenti.php e in vari componenti
     */
    $arrayAnimazioni = array(""=>"Nessuna","fade-up"=>"Entrata dal basso","fade-down"=>"Entrata dall'alto","fade-left"=>"Entrata da destra","fade-right"=>"Entrata da sinistra","zoom-in"=>"Zoom in avanti","zoom-out"=>"Zoom indietro","flip-left"=>"Capovolgi da sinistra","flip-right"=>"Capovolgi da destra","flip-up"=>"Capovolgi dall'alto","flip-down"=>"Capovolgi dal basso");
